﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Telephone_Format
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda IsValidNumber() akceptuje ciąg tekstowy
        // i zwraca wartość true, jeśli zawiera on 10 cyfr.
        // W przeciwnym przypadku wartością zwrotną jest false.
        private bool IsValidNumber(string str)
        {
            const int VALID_LENGTH = 10;  // Długość ciągu tekstowego.
            bool valid = true; // Zmienna oznaczająca poprawność ciągu tekstowego.

            // Sprawdzenie długości ciągu tekstowego.
            if (str.Length == VALID_LENGTH)
            {
                // Sprawdzenie poszczególnych znaków ciągu tekstowego.
                foreach (char ch in str)
                {
                    // Jeżeli znak nie jest cyfrą,
                    // ciąg tekstowy jest niepoprawny.
                    if (!char.IsDigit(ch))
                    {
                        valid = false;
                    }
                }
            }
            else
            {
                // Nieprawidłowa długość ciągu tekstowego.
                valid = false;
            }

            // Zwrot informacji o poprawności ciągu tekstowego.
            return valid;
        }

        // Metoda TelephoneFormat() akceptuje argument w postaci ciągu tekstowego
        // przekazanego przez referencję i formatuje go jako numer telefonu.
        private void TelephoneFormat(ref string str)
        {
            // Najpierw trzeba wstawić nawias otwierający w położeniu o indeksie 0.
            str = str.Insert(0, "(");

            // Najpierw trzeba wstawić nawias zamykający w położeniu o indeksie 4.
            str = str.Insert(4, ")");

            // Później trzeba wstawić myślnik w położeniu o indeksie 8.
            str = str.Insert(8, "-");
        }

        private void formatButton_Click(object sender, EventArgs e)
        {
            // Pobranie kopii danych wejściowych użytkownika bez białych znaków.
            string input = numberTextBox.Text.Trim();

            // Jeżeli dane wejściowe to poprawny numer telefonu, 
            // należy go sformatować i wyświetlić.
            if (IsValidNumber(input))
            {
                TelephoneFormat(ref input);
                MessageBox.Show(input);
            }
            else
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show("Nieprawidłowe dane wejściowe");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
